// ==UserScript==
// @name         样式切换器 for ims.ynydtk.com
// @namespace    http://tampermonkey.net/
// @version      0.1
// @description  在ims.ynydtk.com页面上切换自定义样式
// @author       You
// @match        https://ims.ynydtk.com:8443/buyv2/
// @grant        GM_addStyle
// @grant        GM_getValue
// @grant        GM_setValue
// ==/UserScript==

(function() {
    'use strict';

    // 检查样式是否已应用的存储键
    const STYLE_APPLIED_KEY = 'custom_style_applied';

    // 自定义样式
    const customStyle = `
        .el-radio.is-checked .el-radio__label {
            color: red !important;
            font-weight: bold !important;
            background-color: lightgreen !important;
            padding: 2px 6px 2px 2px !important;
            border-radius: 4px !important;
        }
    `;

    // 创建样式元素
    let styleElement = null;

    // 添加切换按钮
    function addToggleButton() {
        const button = document.createElement('button');
        button.textContent = '切换样式';

        // 按钮样式 - 居中位置
        button.style.position = 'fixed';
        button.style.top = '20%';
        button.style.left = '50%';
        button.style.transform = 'translate(-50%, -50%)';
        button.style.zIndex = '9999';
        button.style.padding = '8px 16px';
        button.style.backgroundColor = '#4CAF50';
        button.style.color = 'white';
        button.style.border = 'none';
        button.style.borderRadius = '4px';
        button.style.cursor = 'pointer';
        button.style.fontSize = '16px';
        button.style.boxShadow = '0 2px 5px rgba(0,0,0,0.2)';

        // 初始化状态
        const isApplied = GM_getValue(STYLE_APPLIED_KEY, false);
        updateButtonState(button, isApplied);
        if (isApplied) {
            applyStyle();
        }

        button.addEventListener('click', function() {
            const newState = !GM_getValue(STYLE_APPLIED_KEY, false);
            GM_setValue(STYLE_APPLIED_KEY, newState);
            updateButtonState(button, newState);

            if (newState) {
                applyStyle();
            } else {
                removeStyle();
            }
        });

        document.body.appendChild(button);
    }

    // 更新按钮状态
    function updateButtonState(button, isApplied) {
        if (isApplied) {
            button.textContent = '取消样式';
            button.style.backgroundColor = '#f44336';
        } else {
            button.textContent = '应用样式';
            button.style.backgroundColor = '#4CAF50';
        }
    }

    // 应用样式
    function applyStyle() {
        if (!styleElement) {
            styleElement = document.createElement('style');
            styleElement.id = 'custom-radio-style';
            styleElement.textContent = customStyle;
            document.head.appendChild(styleElement);
        }
    }

    // 移除样式
    function removeStyle() {
        if (styleElement) {
            styleElement.remove();
            styleElement = null;
        }
    }

    // 等待页面加载完成后添加按钮
    if (document.readyState === 'complete' || document.readyState === 'interactive') {
        setTimeout(addToggleButton, 1000);
    } else {
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(addToggleButton, 1000);
        });
    }
})();
